import com.jayway.restassured.response.Response;
import org.joda.time.DateTime;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import com.jayway.restassured.RestAssured;
import com.xebialabs.restito.server.StubServer;

import java.util.Date;

import static com.jayway.restassured.RestAssured.when;

public class MockServiceTest {
    private StubServer server;

    @Before
    public void start() {
        server = new StubServer().run();
        RestAssured.port = server.getPort();
    }

    @After
    public void stop() {
        server.stop();
    }

    @Test
    public void facilityProviderMockTest() {
        new FacilityProviderMock().run(server);

//        expect().content(containsString("facilityProviderList")).when().get("/facility-provider");
        Response response = when().get("/VeteranAppointmentRequestService/v4/rest/direct-scheduling/patient/EDIPI/0000000008/facility-provider").then().extract().response();
        System.out.println(response.asString());

        response = when().get("/VeteranAppointmentRequestService/v4/rest/direct-scheduling/patient/EDIPI/0000000003/facility-provider").then().extract().response();
        System.out.println(response.asString());

        response = when().get("/VeteranAppointmentRequestService/v4/rest/direct-scheduling/patient/EDIPI/00000000123/facility-provider").then().extract().response();
        System.out.println(response.asString());

        response = when().get("/VeteranAppointmentRequestService/v4/rest/direct-scheduling/patient/EDIPI/D123401/facility-provider").then().extract().response();
        System.out.println(response.asString());
    }

    @Test
    public void availableApptSlotsMockTest() {
        new AvailableAppointmentSlotsMock().run(server);

        Response response = when().get("/available-appointment-slots?startDate=02/17/2016&endDate=05/17/2016&clinicIds=458,1779,1547")
            .then().extract().response();
//        System.out.println(response.asString());
    }

    @Test
    public void createAppointmentSlotsPerDayTest() {
        AvailableAppointmentSlotsMock mock = new AvailableAppointmentSlotsMock();

        Date today = mock.parse("01/12/2016");
        System.out.println(mock.createAppointmentSlotsPerDay("xyz", today, new DateTime(today.getTime()).plusDays(1).toDate()));
    }

    @Test
    public void postAppointmentTest() {
        new BookedAppointmentsMock().run(server);

        Response response = when().post("/VeteranAppointmentRequestService/v4/rest/direct-scheduling/site/777/patient/EDIPI/0000000001/booked-appointments");
        System.out.println(response.asString());
        response = when().post("/VeteranAppointmentRequestService/v4/rest/direct-scheduling/site/777/patient/EDIPI/34567/booked-appointments");
        System.out.println(response.asString());
    }

    @Test
    public void cancelAppointmentTest() {
        new CancelAppointmentMock().run(server);

        Response response = when().put("/VeteranAppointmentRequestService/v4/rest/direct-scheduling/site/777/patient/EDIPI/1/cancel-appointment");
        System.out.println(response.asString());
        response = when().put("/VeteranAppointmentRequestService/v4/rest/direct-scheduling/site/777/patient/EDIPI/12345/cancel-appointment");
        System.out.println(response.asString());
    }

    @Test
    public void patientClinicalServicesTest() {
        new PatientClinicalServicesMock().run(server);

        Response response = when().get("/VeteranAppointmentRequestService/v4/rest/clinical-services/site/777/patient/EDIPI/0000000003/patient-clinical-services");
        System.out.println(response.asString());

    }
}
